;Script file for Eudora versions 3.0.5 and 4.0 by Ken Gould
;Copyright 1999 Henter-Joyce, Inc.
;Modified with some new functions and for better performance with Eudora 3.0.5 by Ken Gould, 1/4/98
;Expanded to work with Eudora 3 or 4 by Ken Gould, 2/15/98
;modified by Ken Gould, 5/26/98, to allow toggling of download message status on and off
; Modified by Dave Baker, 1/99 
; SayFocusedWindow for speaking static text in dialog boxes
; Preview Pane reads from messages list 
; modified 3/3/99 DaveB
;Revision and modifications 3/29/99 by D.B

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "eudora.jsm" ; Eudora message file
include "eudora.jsh"


Globals
Handle EditHandle,
Int EudoraVersion,
Int EudoraFirstTime,
Int DownloadSpeak,
	int RunDialogFirst,
	int nSuppressEcho


Void Function AutoStartEvent ()
Let EudoraVersion = GetEudoraVersion ()
let RunDialogFirst = 0
if StringContains (GetVersionInfoString (GetAppFilePath (), "FileVersion"), "4.2")
then Pause()
  if GetWindowClass (GetFocus ())=="SysTreeView32"
then ScheduleFunction ("CloseTree", 40)
endif
endif
If (EudoraFirstTime == 0) Then
         Let EudoraFirstTime =1
         Let DownloadSpeak =0
         If (GetVerbosity () ==beginner) then
                 Say (msg39, OT_HELP) ; "For a list of Eudora hot key functions, press Insert+H."
                 SayExtendedHelpHotkey()
         EndIf
EndIf
EndFunction

Function CloseTree (){ctrl+f4}
pause()
{ctrl+1}
EndFunction

Void Function SayNonHighlightedText (handle HWND, string Buffer)
var
	string TheClass
; To automatically close and speak the download information
;Added by Ken Gould
If StringContains (buffer, "Sorry, you don't") || StringContains (buffer, "You have new") Then
If (! DialogActive ()) then
	{SpaceBar}
	SpeechOff ()
	Pause ()
	JAWSCursor ()
	RouteJAWSToPC ()
	JAWSPageDown ()
	JAWSHome ()
	PriorLine ()
	RestrictCursor (ON)
	JAWSPageUp ()
	JAWSHome ()
	RestrictCursor (OFF)
	Pause ()
	If GetWord () == "close" Then
		Pause ()
		LeftMouseButton ()
		EndIf
		SpeechOn ()
		PCCursor ()
		Return
	EndIf
EndIf
let TheClass = GetWindowClass(hwnd)
; for the SpellCheck dialog
If (GetControlID (hwnd) == ID_Spell_Mistake) then
	;wcEdit2 = "Edit"
	If (GetWindowClass (GetFocus ()) == wcEdit2) then
		;wn20 = "Check Spelling"
		If(GetWindowName (GetParent (GetFocus ())) == wn20) then
				PerformScript SpellingErrorAndCorrection()
				Return
					EndIf ; end of Window Name check
	EndIf ; end of class check
EndIf ; end of Control ID check
;The following section prevents excess verbiage during download
If (StringContains (Buffer, msg107) || ; "Verif"
StringContains (Buffer, msg108) || ; "Shut"
StringContains (Buffer, msg109) ||; "Log"
StringContains (Buffer, msg110) || ; "UIDL"
StringContains (Buffer, msg111) || ; "Authen"
StringContains (Buffer, msg112) || ; "Quit"
StringContains (Buffer, msg113) || ; "connect"
StringContains (Buffer, msg114) || ; "User"
StringContains (Buffer, msg115) || ; "new mail"
StringContains (Buffer, msg116) || ; "Starting"
StringContains (Buffer, msg117) || ; "RETR"
StringContains (Buffer, msg118) ||; "DELE"
StringContains (Buffer, msg125) || ;"Waiting"
StringContains (Buffer, msg127) || ;"Dialing"
StringContains (Buffer, msg119)) Then; "LIST"
	return
EndIf; End of excess verbiage during download test
if ((GetScreenEcho() > 1) ||
;wn36="#32771"
; wcDialog2 = ; "#32771"
(TheClass == wcDialog2 ) || 
(TheClass == wcToolTips) || ; "ToolTips_Class32"
(GetControlID (hwnd) == 8081 &&DownLoadSpeak != 0) || ;test added by Ken Gould to make 4.1 download speak
((TheClass == wcStatic) && (GetWindowClass (GetFocus ())) == "Button") && (DownloadSpeak != 0)) then; "Static"
if GetVerbosity ()>=1 then
if StringContains (buffer, "download")
then let buffer=StringLeft (buffer, 2)
endif 
endif
	Say (buffer, OT_BUFFER)
EndIf
EndFunction

Void Function SayHighlightedText (handle hwnd, string buffer)
;Added by Ken Gould
; To prevent extra chatter in the Task List while downloading mail
If (StringContains (Buffer, msg107) || ; "Verif"
StringContains (Buffer, msg108) || ; "Shut"
StringContains (Buffer, msg109) ||; "Log"
StringContains (Buffer, msg110) || ; "UIDL"
StringContains (Buffer, msg111) || ; "Authen"
StringContains (Buffer, msg112) || ; "Quit"
StringContains (Buffer, msg113) || ; "connect"
StringContains (Buffer, msg114) || ; "User"
StringContains (Buffer, msg115) || ; "new mail"
StringContains (Buffer, msg116) || ; "Starting"
StringContains (Buffer, msg117) || ; "RETR"
StringContains (Buffer, msg118) ||; "DELE"
StringContains (Buffer, msg125) || ;"Waiting"
StringContains (Buffer, msg127) || ;"Dialing"
StringContains (Buffer, msg119)) Then; "LIST"
Return
EndIf
;wn20 = "Check Spelling"
If(GetWindowName (GetParent (GetFocus ())) == wn20) &&
(GetControlID (GetFocus ()) == ID_Spell_Correct) then
	If hwnd != GlobalFocusWindow then
		Return
	EndIf
EndIf
Say (buffer, OT_BUFFER)
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	handle AppWindow,
	string RealWindowName
If (GlobalMenuMode > 0) then
	FocusChangedEvent (FocusWindow, PrevWindow)
	Return
EndIf
let RealWindow = GetRealWindow (FocusWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
If (GetControlID (FocusWindow) == ID_View) ||
(GetControlID (FocusWindow) == ID_Edit) ||
(GetWindowClass (GetCurrentWindow ()) == WCEdit) then
	if (GetVerbosity () == 0) then
		Say (msg3, OT_CONTROL_NAME) ; "Edit"
	EndIf ; End of Verbosity check 
	CaretVisible ()
	If (GetControlID (PrevWindow) != ID_Bcc) then
		SayLine ()
	EndIf
EndIf
If (GetControlID (GetCurrentWindow ()) == 	ID_Find_Edit) then
	If (GetWindowName (RealWindow)!= GetWindowName (GlobalPrevReal)) then
		SayWindowTypeAndText (RealWindow)
	EndIf ; End of if it is edit
	SayWindowTypeAndText (GetCurrentWindow ())
	let GlobalPrevApp = AppWindow
	let GlobalPrevReal = RealWindow
	let GlobalFocusWindow = FocusWindow
	Return
EndIf; End of Find Edit
; wn20 = "Check Spelling"
If (RealWindowName == wn20) then
	;If (GetControlID (FocusWindow) == ID_Spell_Correct) then
	If (RealWindow != GlobalPrevReal) then 
		Pause ()
	Else
		SayWindowTypeAndText (FocusWindow)
	EndIf
	let GlobalPrevApp = AppWindow
	let GlobalPrevReal = RealWindow
	let GlobalFocusWindow = FocusWindow
	Return
EndIf
; wn24 = "Find",
If (RealWindowName == wn24) then
	SayWindowTypeAndText (FocusWindow)
	let GlobalPrevApp = AppWindow
	let GlobalPrevReal = RealWindow
	let GlobalFocusWindow = FocusWindow
	return
EndIf
; for the Warning dialog
;wn1 = "Warning!"
if (GetWindowName (GetParent (GetFocus ()) ) == wn1) then
	;wn2 = "Warning"
	If (GetWindowName (GetParent (PrevWindow)) == wn2) then
		SayWindowTypeAndText (GetFocus ()); don't overtalk
		let GlobalPrevApp = AppWindow
		let GlobalPrevReal = RealWindow
		let GlobalFocusWindow = FocusWindow
		Return
	EndIf
EndIf
If (GetWindowName (GetRealWindow (FocusWindow)) == wn11) || ; "Filters"
(GetWindowName (GetParent (FocusWindow)) == wn11) then ; "Filters"
	SayWindowTypeAndText (FocusWindow)
	let GlobalPrevApp = AppWindow
	let GlobalPrevReal = RealWindow
	let GlobalFocusWindow = FocusWindow
	Return
EndIf
If (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), msg10)) Then; "Address Book"
If (GetCurrentControlID () == 1453 || GetCurrentControlID () == 432) Then 
Say (msg1, OT_CONTROL_NAME) ; "E-mail address"
SayWindow (GetCurrentWindow (), read_everything)
EndIf
If (GetCurrentControlID () == 1454 || GetCurrentControlID () == 433) Then 
Say (msg2, OT_CONTROL_NAME) ; "Notes"
EndIf
EndIf
; for Password Dialogs
if (GetWindowName (GetParent (GetFocus ())) == msg102) then; "Enter Password"
	SayWindowTypeAndText (FocusWindow)
	let GlobalPrevApp = AppWindow
	let GlobalPrevReal = RealWindow
	let GlobalFocusWindow = FocusWindow
	Return
EndIf
; for New Message
; to avoid extra chatter when writing new message
If (GetControlID (GetParent (GetFocus ())) == ID_View) &&
(GetWindowClass (GetFocus ()) == WCEdit) ||
(GetWindowClass (GetFocus ()) == wcEdit2) &&
(GetControlID (GetCurrentWindow ()) <= 5057) then
	If (PrevWindow != GetParent (GetParent (FocusWindow))) &&
	StringContains (GetAppTitle (), "Eudora") then
		SayWindowTypeAndText (GetFocus ())
		let GlobalPrevApp = AppWindow
		let GlobalPrevReal = RealWindow
		let GlobalFocusWindow = FocusWindow
		Return
	EndIf ; if title has changed
EndIf ; end of new message
; For the Find Dialog


let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	If (GetWindowClass (FocusWindow) == wcListView) &&; "SysListView32"
	(PrevWindow != FocusWindow) then
	SayWindowTypeAndText (FocusWindow)
EndIf
	SayWindowTypeAndText(AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application, 
; for example, progman.jms
let GlobalFocusWindow = FocusWindow
SayFocusedWindow()  ; will use global variable "GlobalFocusWindow"
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
var
	int counter,
	handle WinHandle,
	handle hWnd,
	string TheClass
let WinHandle = GetCurrentWindow ()
let hWnd = FindDescendantWindow (GetAppMainWindow (winHandle), ID_ListBox)
let TheClass = GetWindowClass (WinHandle)

; if no windows are open
if (! hWnd) &&
(TheClass == WCNoWindows) then
	If(GetVerbosity () == Beginner) then
		Say (msg96, OT_HELP) ; "There are no mailboxes open at this time"
	Say (msg97, OT_HELP) ; "The window with focus will not serve you until you open a mailbox"
		Say (msg98, OT_HELP) ; "Press control plus 1 to open the Inbox"
	Else
	SayFocusedWindow ()
	EndIf ; End of the verbosity check
	Return
EndIf ; end of NoWindows 
; for the Jaws list boxes
let RunDialogFirst = 0
If (GetWindowName (GetRealWindow (GetFocus ())) == wn3) ||; "Adjust JAWS Verbosity"
(GetWindowName (GetRealWindow (GetFocus ())) == wn4) ||; "Run JAWS Manager"
(GetWindowName (GetRealWindow (GetFocus ())) == wn24) || ; "Find"
(GetWindowName (GetRealWindow (GetFocus ())) == wn25) ||; "Graphics Labeler"
(GetWindowName (GetRealWindow (GetFocus ())) == wn11) || ; "Filters"
(GetWindowName (GetParent (GetFocus ())) == wn11) || ; "Filters"
(GetWindowName (GetParent (GetFocus ())) == wn25) ||
(GetWindowName (GetRealWindow (GetFocus ())) == wn5) ||; "Select a task Tray icon:"
(GetWindowName (GetRealWindow (GetFocus ())) == wn30) || ; "Select A System Tray Icon"
(GetWindowName (GetRealWindow (GetFocus ())) == wn27) || ; "New Nickname"
(GetWindowName (GetRealWindow (GetFocus ())) == wn28) || ; "Make Filter"
(GetWindowName (GetRealWindow (GetFocus ())) == wn22) ||; "JAWS Find"
(GetWindowName (GetRealWindow (GetFocus ())) == wn23) || ; "Working Offline"
(GetWindowName (GetParent (GetFocus ())) == wn23) then ; "Working Offline"
	SayFocusedWindow ()
	Return
Endif
; For the Personality Settings dialogs
If (StringContains (GetWindowName (GetParent (GetFocus ())), msg103)) ||; "Account Settings for"
(GetWindowName (GetParent (GetFocus ())) == wn6) then; "Send Queued Messages"
	let nSuppressEcho = true
	SayFocusedWindow ()
	Return
EndIf

; for some standard dialogs 
If (GetWindowName (GetParent (GetFocus ())) == wn7) ||; "Options"
(GetWindowName (GetParent (GetFocus ())) == wn8) ||; "Register Eudora Light"
(GetWindowName (GetParent (GetFocus ())) == wn9) ||; "Sending Styles"
(GetWindowName (GetParent (GetFocus ())) == wn10) ||; "Note"
(GetWindowName (GetParent (GetFocus ())) == wn12) ||; "Installed Message Plugins"
(GetWindowName (GetParent (GetFocus ())) == wn13) ||; "Corrupt Mailbox"
(StringContains (GetWindowName (GetParent (GetFocus ())), msg104) ||; "Eudora"
(GetWindowName (GetParent (GetFocus ())) == "New Account Wizard") ||
(GetWindowName (GetParent (GetFocus ())) == wn14) ||; "Make Address Book Entry"
(GetWindowName (GetParent (GetFocus ())) == wn15) ||; "Make Address Book Entry"
(GetWindowName (GetParent (GetParent (GetFocus ()))) == wn16) ||; "Address Book"
(GetWindowName (GetParent (GetFocus ())) == wn17) ||; "Duplicate Nickname"
(GetWindowName (GetParent (GetFocus ())) == wn18)) then; "Tip Of The Day"
	SayFocusedWindow ()
	Return
Endif
; for the File Browser
if (GetControlID (GetFocus ()) == ID_Browse_Tree) ||
(GetControlID (GetFocus ()) == ID_Browse_List) ||
(GetControlID (GetFocus ()) == ID_Browse_Combo) then
	SayFocusedWindow ()
	Return
EndIf

; for the Progress dialog
; since Ken Gould has integrated DownloadSpeak,
; let's not break it while other boxes are fixed
If (GetWindowName (GetParent (GetFocus ())) == wn19) then; "Progress"
	If (DownloadSpeak ==0) then
let nSuppressEcho = 1
	Else
	SayFocusedWindow ()
	EndIf
	Return
EndIf

; for New Message
If (GetControlID (GetParent (GetFocus ())) == ID_View) &&
(GetControlID (GetCurrentWindow ()) <= 5057) then
	SayFocusedWindow ()
	Return
EndIf
; For the Check Spelling dialog
If (GetWindowClass (GetRealWindow (GetFocus ())) == WCDialog) &&
(GetWindowName (GetParent (GetFocus ())) == wn20) then; "Check Spelling"
	If (GetControlID (GetFocus ()) == ID_Spell_Correct) then
		SayWindowTypeAndText (GetFocus ())
		Return
	EndIf
SayFocusedWindow ()
	Return
EndIf

if (GetWindowClass (GetParent (GetFocus ())) == WCDialog) then
	SaveCursor ()
	InvisibleCursor ()
	RouteInvisibleToPc ()
; for the Warning dialog
	If (GetWindowName (GetRealWindow (GetFocus ())) == wn1) then; "Warning!"
		If (RunDialogFirst == 0) then
			While (GetControlID (GetCurrentWindow ()) != ID_Static) &&
			(counter != 4)
				let counter = counter + 1
				MoveToWindow (GetNextWindow (GetCurrentWindow ()))
			EndWhile
			SayWindow (GetCurrentWindow (), Read_Everything)
		RestoreCursor ()
			let RunDialogFirst = 1
	EndIf; End of RunDialogFirst
	SayWindowTypeAndText (GetFocus ())
If (GetWindowClass (GetFocus ()) != "Button") then
	let RunDialogFirst = 0
EndIf
	Return
EndIf
	; for the New Mail dialog
	If (GetWindowClass (GetRealWindow (GetFocus ())) == WCDialog) &&
	(GetWindowName (GetParent (GetFocus ())) == "No New Mail") ||
	(GetWindowName (GetParent (GetFocus ())) == wn21) then; "New Mail"
		SayFocusedWindow ()
		Return
	EndIf
; for Windows standard dialogs
; such as open file, save as, etc.
	If (GetWindowClass (GetNextWindow (GetFirstChild (GetParent (GetFocus ())))) == wcComboBox) then; "ComboBox"
		SayFocusedWindow ()
		Return
	EndIf
; for exit and other dialogs
	While (GetWindowClass (GetCurrentWindow ()) != "Static") &&
	(counter != 4)
		let counter = counter + 1
		MoveToWindow (GetNextWindow (GetCurrentWindow ()))
	EndWhile
		SayWindow (GetCurrentWindow (), Read_Everything)
	SayWindowTypeAndText (GetFocus ())
	RestoreCursor ()
	Return
EndIf
If (GetWindowClass (GetFocus ()) != wcButton) then; "Button"
	let RunDialogFirst = 0
EndIf
let nSuppressEcho = 0
SayFocusedWindow ()
EndFunction

Void Function AutoSayHeader (int nID)
; by John Carson
; Used in Microsoft Outlook 
var
	handle hWnd
let hWnd = FindDescendantWindow (GetTopLevelWindow (GetFocus ()), nId)
SaveCursor ()
If (Hwnd) then
  invisibleCursor ()
  MoveToWindow (Hwnd)
  SayWindow (Hwnd, read_everything)
EndIf
EndFunction

Int Function GetEudoraVersion ()
;Determines what version of Eudora is being used
var
	int nVersion
let nVersion = GetProgramVersion (GetAppFilePath ())
	return nVersion	
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Eudora")
EndScript

Script HotKeyHelp ()
;Script for hot key help
; Added 3/4/98, DaveB
; to fix the bug when no windows are open
var
	handle hWnd,
	handle winHandle,
	string TheClass
If (GlobalMenuMode > 0) then
	PerformScript HotKeyHelp ()
	Return
EndIf
let hWnd = FindDescendantWindow (GetAppMainWindow (winHandle), ID_ListBox)
let winHandle = GetCurrentWindow () 
let TheClass = GetWindowClass (winHandle)

SayExtendedHelpHotkey()
; if no windows are open
if (! hWnd) &&
(TheClass == WCNoWindows) then
	Say (msg96, OT_HELP) ; "There are no mailboxes open at this time"
	Say (msg97, OT_HELP) ; "The window with focus will not serve you until you open a mailbox"
	Say (msg98, OT_HELP) ; "Press control plus 1 to open the Inbox"
	Return
EndIf
; for the Task List View
; Only in Version 4
; and only if activated
If (GetWindowClass (GetCurrentWindow ()) == wcListView) then; "SysListView32"
	Say (msg72 + msg88, OT_HELP) ; "This is the Task List"
	Say (msg89 + GetScriptKeyName ("CloseTaskList") + msg90, OT_HELP) ; "Press ctrl + insert + f4 to close"
	Return
EndIf
If (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == WCDialog) then
	; for Check Spelling dialog
	;wn20 = "Check Spelling"
	If (GetWindowName (GetParent (GetFocus ())) == wn20) then
		Say (msg22, OT_HELP) ; "While in the spell checker, use control+Shift+U to hear the unknown word."
		Say (msg23, OT_HELP) ; "Use control+shift+O to hear the default new word replacement."
		Say (msg24, OT_HELP) ; "Or, if you prefer, use Insert+F7 to hear the misspelled word and default correction with one keystroke, as in Microsoft Word."
		Say (msg25, OT_HELP) ; "Use Insert+C to hear the misspelled word in context."
		Say (msg26, OT_HELP) ; "If this hot key says the highlighted word is covered up, change the message window back to restored for better results."
		Say (msg27, OT_HELP) ; "Always enter the spell checker with Control+6 rather than the menus, or the Read Word in Context function will not work correctly."
	EndIf
	HotKeyHelpDefaultLoop ()
	return
EndIf
; For the Address Book Window
; properties multipage dialog
If (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), msg10)) Then; "Address Book"
	;wcRichEdit = "RICHEDIT"
	If (GetWindowClass (GetCurrentWindow ()) == wcRichEdit) ||
	; wcTabControl = "SysTabControl32"
	(GetWindowClass (GetCurrentWindow ()) == wcTabControl) then
		Say (msg49, OT_HELP) ; "use tab and shift + tab to move between the fields"
		Say (msg50, OT_HELP) ; "use ctrl + tab and shift + ctrl + tab to switch between the Address, notes and info pages"
		Return
	EndIf
; main nicknames pane
	Say (msg43, OT_HELP) ; "To delete the highlighted nickname, press alt + d"
	Say (msg44, OT_HELP) ; "To create a new nickname, press alt + n"
	Say (msg45, OT_HELP) ; "After selecting a nickname in the tree view, use the following hot keys for message composition"
	Say (msg46, OT_HELP) ; "To address a message to the nickName, press alt + t"
	Say (msg47, OT_HELP) ; "For CC, press alt + c"
	Say (msg48, OT_HELP) ; "for BCC, press alt + b"
	Say (msg42, OT_HELP) ; "Press f6 to move to the properties multiPage dialog"
	return
EndIf
; for the messages list
;wcListBox = "ListBox"
If (GetWindowClass (GetCurrentWindow ()) == wcListBox) then
	Say (msg51, OT_HELP) ; "Use the up and down arrows to select the message"
	Say (msg52, OT_HELP) ; "press ctrl + insert + down arrow to preview the selected message, or press enter to open it"
	return
EndIf
	; for the preview pane window, as it has similar properties
	; this is not an option in Version 3
		If (GetEudoraVersion () >= 4) &&
		(GetWindowClass (GetFirstChild (GetPriorWindow (GetCurrentWindow ()))) == wcListBox) then
		Say (msg62, OT_HELP) ; "This is the preview pane window"
		Say (msg63, OT_HELP); "Press tab to return to the list box"
		Say (msg64, OT_HELP) ; "Select a message to preview and press control + insert + down arrow to read the subject and text in the preview pane"
		Say (msg65, OT_HELP) ; "To read the entire message, select it in the list and press enter"
		Return
	EndIf
; Message Windows
; for Eudora Version 4
If (GetEudoraVersion () >= 4) &&
(GetControlID (GetCurrentWindow ()) == ID_Edit) ||
(GetWindowClass (GetCurrentWindow ()) == WCEdit) ||
(GetControlID (GetCurrentWindow ()) == ID_View) ||
(GetControlID (GetParent (GetCurrentWindow ())) == ID_View) then
	Say (msg20, OT_HELP) ; "For optimum results with Eudora scripts, maximize Eudora, all message windows,  and all mail boxes."
	Say (msg21, OT_HELP) ; "To open the signature selection combo box while creating a new message, use control+shift+S."
	Say (msg28, OT_HELP) ; "Maximum Download and upload message information is not spoken automatically by default.  To activate or silence this while on line, use Control+Shift+D  to toggle the download speaking status."
	Say (msg29, OT_HELP) ; "While creating a new message, use Control+Shift+t to hear who the message is to,"
	Say (msg30, OT_HELP) ; "use Control+Shift+c to hear the CCese, and use Control+Shift +B to hear the BCCese."
	Say (msg31, OT_HELP) ; "These three hot keys will only work properly if your message window is maximized."
	Return
EndIf ; end of Version 4
; now for Version 3
If (GetEudoraVersion () << 4) &&
(GetControlID (GetCurrentWindow ()) == ID_Edit) ||
(GetWindowClass (GetCurrentWindow ()) == WCEdit) ||
(GetControlID (GetCurrentWindow ()) == ID_View) ||
(GetControlID (GetParent (GetCurrentWindow ())) == ID_View) then
				Say (msg92, OT_HELP) ; "This is the message edit or preview window in Version 3"
		Say (msg20, OT_HELP) ; "For optimum results with Eudora scripts, maximize Eudora, all message windows,  and all mail boxes."
		Say (msg21, OT_HELP) ; "To open the signature selection combo box while creating a new message, use control+shift+S."
		Say (msg28, OT_HELP) ; "Maximum Download and upload message information is not spoken automatically by default.  To activate or silence this while on line, use Control+Shift+D  to toggle the download speaking status."
		Say (msg29, OT_HELP) ; "While creating a new message, use Control+Shift+t to hear who the message is to,"
		Say (msg30, OT_HELP) ; "use Control+Shift+c to hear the CCese, and use Control+Shift +B to hear the BCCese."
		Say (msg31, OT_HELP) ; "These three hot keys will only work properly if your message window is maximized."
	Say (msg32, OT_HELP) ; "To respond directly to the author of a message you have received from a list server, use Control+Shift+A"
		Return
	EndIf; end of Version 3
	PerformScript HotKeyHelp()
EndScript

Script ScreenSensitiveHelp ()
var
	handle WinHandle,
	handle hWnd,
	string TheClass
If (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp ()
	Return
EndIf
let WinHandle = GetCurrentWindow ()
let hWnd = FindDescendantWindow (GetAppMainWindow (winHandle), ID_ListBox)
let TheClass = GetWindowClass (WinHandle)
; AppFileTopic
If (IsSameScript ()) then
	AppFileTopic ()
	Return
EndIf
; if no windows are open
if (! hWnd) &&
(TheClass == WCNoWindows) then
	Say (msg96, OT_HELP) ; "There are no mailboxes open at this time"
	Say (msg97, OT_HELP) ; "The window with focus will not serve you until you open a mailbox"
	Say (msg98, OT_HELP) ; "Press control plus 1 to open the Inbox"
	Return
EndIf
; for the Task List View
; Only in Version 4
; and only if activated
;wcListView = "SysListView32"
If (TheClass  == wcListView) then
	Say (msg72 + msg88, OT_HELP) ; "This is the Task List"
	Say (msg89 + GetScriptKeyName ("CloseTaskList") + msg90, OT_HELP) ; "Press ctrl + insert + f4 to close"
	Return
EndIf
let WinHandle = GetRealWindow (WinHandle)
; for the Check Spelling dialog
If (GetWindowClass (WinHandle) == WCDialog) &&
(GetWindowName (GetParent (GetFocus ())) == wn20) then; "Check Spelling"
	Say (msg53, OT_HELP) ; "You are in the SpellCheck dialog"
	Say (msg22, OT_HELP) ; "While in the spell checker, use control+Shift+U to hear the unknown word."
	Say (msg23, OT_HELP) ; "Use control+shift+O to hear the default new word replacement."
	Say (msg24, OT_HELP) ; "Or, if you prefer, use Insert+F7 to hear the misspelled word and default correction with one keystroke, as in Microsoft Word."
	Say (msg25, OT_HELP) ; "Use Insert+C to hear the misspelled word in context."
	Say (msg26, OT_HELP) ; "If this hot key says the highlighted word is covered up, change the message window back to restored for better results."
	Say (msg27, OT_HELP) ; "Always enter the spell checker with Control+6 rather than the menus, or the Read Word in Context function will not work correctly."
	Return
EndIf
let WinHandle = GetCurrentWindow ()
; if Microsoft Viewer is on
if (GetWindowClass (WinHandle) == WCMSViewer) then
	Say (msg54, OT_HELP) ; "You are in a message viewing window",
	Say (msg55, OT_HELP) ; "but the Microsoft Viewer is turned on, so the cursor will not work"
 Say (msg56, OT_HELP) ; "To turn it off, uncheck the "Use Microsoft Viewer" checkbox in the Viewing Mail option in the Tools Options dialog"
	Return
EndIf
; for message viewing windows with a caret
If (GetControlID (WinHandle) == ID_View) then
	Say (msg57, OT_HELP) ; "This is a message viewing window"
	Say (msg58, OT_HELP) ; "This is for reading, not editing, your messages"
	Say (msg59, OT_HELP) ; "You can navigate with the PC cursor and select text"
	Return
EndIf 
If (TheClass == WCEdit) ||
; for Version 3
;wcRichEdit = "RICHEDIt"
(TheClass == wcRichEdit) &&
(GetControlID (WinHandle) == ID_Edit) then
	; for the preview pane window, as it has similar properties
	; this is not an option in Version 3
		If (GetEudoraVersion () >= 4) &&
		(GetWindowClass (GetFirstChild (GetPriorWindow (WinHandle))) == "ListBox") then
		Say (msg62, OT_HELP) ; "This is the preview pane window"
		Say (msg63, OT_HELP); "Press tab to return to the list box"
		Say (msg64, OT_HELP) ; "Select a message to preview and press control + insert + down arrow to read the subject and text in the preview pane"
		Say (msg65, OT_HELP) ; "To read the entire message, select it in the list and press enter"
		Return
	EndIf
	If (GetEudoraVersion () >= 4) then
		Say (msg60, OT_HELP) ; "This is the message edit window"
		Say (msg61, OT_HELP) ; "After completing your message, press control + 6 to spellcheck, control + e to send"
	else
	Say (msg92, OT_HELP) ; "This is the message edit or preview window in Version 3"
	Say (msg61, OT_HELP) ; "After completing your message, press control + 6 to spellcheck, control + e to send"
	Say (msg59, OT_HELP) ; "You can navigate with the PC cursor and select text"
	EndIf
	Return
Endif
;wcListBox = "ListBox"
If (TheClass == wcListBox) then
	Say (msg66, OT_HELP) ; "This is the list box containing the messages in the active mailbox"
	Say (msg64, OT_HELP) ; "Select a message to preview and press control + insert + down arrow to read the subject and text in the preview pane"
	Say (msg65, OT_HELP) ; "To read the entire message, select it in the list and press enter"
	Return
EndIf
; For the Address Book Window
; properties multipage dialog
;msg10 = "Address Book"
If (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), msg10)) Then
	If (GetWindowClass (GetCurrentWindow ()) == wcRichEdit) ||
	(GetWindowClass (GetCurrentWindow ()) == wcTabControl) then
		Say (msg67, OT_HELP) ; "This is the Nickname properties pane of the Address book"
		Say (msg49, OT_HELP) ; "use tab and shift + tab to move between the fields"
		Say (msg50, OT_HELP) ; "use ctrl + tab and shift + ctrl + tab to switch between the Address, notes and info pages"
		Say (msg68, OT_HELP) ; "press f6 to switch to the main Address Book pane"
		Return
	EndIf ; end of NickName Properties
	; for main address book pane
	Say (msg69, OT_HELP) ; "This is the main address book window, containing your nicknames and available options"
	If (TheClass == wcTreeView) then
		Say (msg70, OT_HELP) ; "This is the tree view containing your nicknames and address book folders"
		Say (msg71, OT_HELP) ; "Use the up and down arrows to select an item, use the tab key to move to the next control"
	ElIf (TheClass == wcButton) then
		; the checkbox has the same class as the button
		If (GetWindowTypeCode (WinHandle) == WT_Checkbox) then
			Say (msg74, OT_HELP) ; "This is the Expand Nickname checkbox"
			Say (msg75, OT_HELP) ; "Press the space bar to toggle it, press the tab key to move to the next control"
			Return
		EndIf ; end of checkbox routine
		Say (msg72, OT_HELP) ; "This is the"
		SayWindowTypeAndText (WinHandle)
		Say (msg73, OT_HELP) ; "Press enter or space bar to activate it, press the tab key to move to the next control"
	ElIf (TheClass == wcComboBox) then 
		Say (msg76, OT_HELP) ; "This is the View By combo box"
		Say (msg71, OT_HELP); "Use the up and down arrows to select an item, use the tab key to move to the next control"
	EndIf
	Return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Script SayLine ()	
; To compensate for misreading in the To field in Version 4.2 
var
	handle hWnd,
	int nId
let hWnd = GetFocus ();
let nId = GetControlID (hWnd)
If (GetControlName () == "To:") &&
(StringLength (GetLine ()) == 0) &&
(IsPcCursor ()) &&
;wcEdit2 = "Edit"
(GetWindowClass (hWnd) == wcEdit2) then
	PerformScript SayWindowPromptAndText()
Else
PerformScript SayLine()
EndIf
EndScript

Script JawsDelete ()
; so the delete dialog will speak properly.
var
	handle winHandle,
	string theClass,
	int cId
let winHandle = GetCurrentWindow ()
let theClass = GetWindowClass (winHandle)
let cId = GetControlID (winHandle)
If (cId == ID_Messages_List) &&
(theClass == wcListBox) &&
(IsPCCursor ()) then
	let nSuppressEcho = true
	{delete}
	let nSuppressEcho = false
	Return
EndIf
PerformScript JawsDelete()
EndScript

Script  NextDocumentWindow() 
var
Int AddressControlID
{control+tab}
delay (1)
Let AddressControlID = GetCurrentControlID ()
if (IsMultiPageDialog ()) then
	Say (GetDialogPageName (), OT_DIALOG_NAME )
	return
endif
If (AddressControlID == 1453 ||AddressControlID == 432) Then
Say (msg1, OT_CONTROL_NAME) ; "E-mail Address"
EndIf
If (AddressControlId == 1454 || AddressControlID == 433) Then
Say (msg2, OT_CONTROL_NAME) ; "Notes"
SayWindow (GetCurrentWindow (), read_everything)
EndIf
EndScript

Script PreviousDocumentWindow() 
Var
Int AddressControlID
{control+shift+tab}
Delay (1)
Let AddressControlID = GetCurrentControlID ()
if (IsMultiPageDialog ()) then
	Say (GetDialogPageName (), OT_DIALOG_NAME )
	return
endif
If (AddressControlID == 1453 || AddressControlID == 432) Then
Say (msg1, OT_CONTROL_NAME) ; "E-mail address"
EndIf
If (AddressControlId == 1454 || AddressControlID == 433) Then
Say (msg2, OT_CONTROL_NAME) ; "Notes"
SayWindow (GetCurrentWindow (), read_everything)
EndIf
EndScript

Script CloseTaskList ()
Say (msg128, OT_MESSAGE) ; "Close Task Status Window"
JAWSCursor ()
RouteJAWSToPC ()
JAWSPageDown ()
JAWSHome ()
PriorLine ()
RestrictCursor (ON)
JAWSPageUp ()
JAWSHome ()
RestrictCursor (OFF)
Pause ()
If GetWord () == "close" Then
LeftMouseButton ()
PCCursor ()
Say (msg129, OT_STATUS)
Else
PCCursor ()
Say (msg130, OT_HELP); "Sorry, couldn't find close symbol."
EndIf
EndScript

Script DownloadSpeak ()
If (DownloadSpeak == 0) Then
Let DownloadSpeak = 1
Say (msg40, OT_MESSAGE) ; "Turning on speaking of download message status."
Return
EndIf
If (DownloadSpeak == 1) Then
Let DownloadSpeak = 0
Say (msg41, OT_MESSAGE) ; "Turning off speaking of download message status."
EndIf
EndScript

Script ReadPreviewPane ()
var
	handle hwnd
If (GetEudoraVersion () >= 4) then
	if (GetWindowClass (GetFocus ()) == wcListBox) &&
	(FindDescendantWindow (GetAppMainWindow (GetFocus ()), ID_ListBox)) then
		; if no messages or none selected
		If (GetCharacter () == "") then
			Say (msg94, OT_MESSAGE) ; "no messages to view or no message is selected"
			Return
		EndIf
		SaveCursor ()
		InvisibleCursor ()
		RouteInvisibleToPc ()
		MoveToWindow (GetNextWindow (GetParent (GetFocus ())))
		If (GetControlID (GetCurrentWindow ()) != ID_Edit) then ; preview pane w/o caret
	RouteInvisibleToPc ()
			JAWSPageDown ()
			PriorLine ()
			PriorLine ()
			PriorLine ()
			PriorLine ()
			If (GetWindowClass (GetCurrentWindow ()) == wcHeader) ||
			(GetWindowClass (GetCurrentWindow ()) == wcListBox) then
				Say (msg91, OT_MESSAGE) ; "Your preview pane is not turned on"
				Return
			EndIf
			Say (msg77, OT_HELP) ; "The Microsoft Viewer is turned on"
			Say (msg56, OT_HELP) ; "To turn it off, uncheck the Use Microsoft Viewer checkbox in the Viewing Mail option in the Tools Options dialog",
		EndIf
		SayWindow (GetCurrentWindow (), Read_Everything)
	Else
		Say (msg78, OT_MESSAGE) ; "You are not in the Messages List Box"
		PerformScript ScreenSensitiveHelp()
	EndIf
	Return
EndIf ; end of Version 4
; back to Version 3
	Say (msg87, OT_MESSAGE) ; "This option is not available in Version 3"
EndScript

Script SpellingErrorAndCorrection ()
;Combines UnknownWord  and NewWord scripts to simulate Insert+F7 of Microsoft Word
If (GetCurrentControlID () != 1194) Then 
Say (msg16, OT_MESSAGE) ; "You must be in the spell checker to use this function."
Return
EndIf
PerformScript UnknownWord()
PerformScript NewWord()
EndScript

Script NewWord ()
;Script to speak default spelling suggestion
Pause ()
If (GetControlID (GetFocus ()) != 1194) ||
;wn20 = "Check Spelling"
(GetWindowName (GetParent (GetFocus ())) != wn20) then
Say (msg16, OT_HELP) ; "You must be in the spell checker to use this function."
Return
EndIf
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
JAWSEnd ()
;msg121 = ":"
If Not (GetCharacter () == msg121) Then
SayLine ()
Delay (4)
SpellString (GetField ())
Else
Say (msg19, OT_MESSAGE) ; "No suggestion offered"
EndIf
EndScript

Script UnknownWord ()
;Script to say unknown word in spell checker
Delay (2)
If (GetControlID (GetFocus()) != 1194) ||
;wn20 = "Check Spelling"
(GetWindowName (GetParent (GetFocus ())) != wn20) then
Say (msg16, OT_HELP) ; "You must be in the spell checker to use this function."
Return
EndIf
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
PriorLine ()
PriorLine ()
JAWSEnd ()
SayLine ()
Delay (4)
SpellWord ()
EndScript

Script ReadWordInContext ()
;Script to read word in context
If (GetControlID (GetFocus ()) != 1194) Then 
Say (msg16, OT_HELP) ; "You must be in the spell checker to use this function."
Return
EndIf
JAWSCursor ()
MoveToWindow (EditHandle)
If (EudoraVersion == 3) Then
FindFirstAttribute (Attrib_Highlight)
EndIf
If (EudoraVersion == 4) Then
FindLastAttribute (Attrib_Highlight)
EndIf
Pause ()
If (StringContains (GetChunk (), msg120)) Then; "Check Spelling"
Say (msg17, OT_HELP) ; "I can't find a highlighted mis-spelled word.  It may be that the Check Spelling dialog is covering it or the word may be in the subject line and isn't being highlighted."
Say (msg18, OT_HELP) ; "Also, make sure your message window is restored and you started the spell checker with Control+6, not the menus."
Else
InvisibleCursor ()
RouteInvisibleToJAWS ()
Pause ()
SayLine ()
EndIf
PcCursor ()
EndScript

Script  OpenSignatures()
;Script to open signature choice list
If (GetVerbosity () == 0) then
	Say (msg100, OT_MESSAGE) ; "Signatures list"
EndIf
;msg106 = "Priority"
If (FindGraphic (GetAppMainWindow (GetCurrentWindow ()), msg106, S_Top, S_Unrestricted)) Then
NextWord () NextWord () NextWord ()
Pause ()
LeftMouseButton ()
PcCursor ()
Else
If GetVerbosity () == 0 then
	Say (msg101, OT_HELP) ; "could not be found."
EndIf
EndIf
EndScript

Script SpellCheck ()
;Script to name spell check keys
Let EditHandle = GetCurrentWindow ()
Pause ()
If GetVerbosity () == 0 then
	Say (msg5, OT_MESSAGE) ; "Spell check"
EndIf
{control+6}
EndScript

Script NewMessage ()
;Script to name New Message keys.
If GetVerbosity () == 0 then
	Say (msg6, OT_MESSAGE) ; "New message"
EndIf
{control+N}
EndScript

Script NewMessageWithOptions ()
;Script to name new message with options keys
If GetVerbosity () == 0 then
	Say (msg6, OT_MESSAGE) ; "New message"
EndIf
{Control+Shift+N}
EndScript

Script CheckMail ()
;Script to name check mail keys
If GetVerbosity () == 0 then
	Say (msg7, OT_MESSAGE) ; "Check mail"
EndIf
{control+M}
; The following commented lines may help if you have many mailboxes or personalities
;Simply remove the ; from the beginning of the next two lines. 
;Delay (20) 
;{End}
EndScript

Script SendMail ()
;Script to name send mail keys
If GetVerbosity () == 0 then
	Say (msg8, OT_MESSAGE) ; "Send Mail"
EndIf
{control+T}
EndScript

Script QueueMessage ()
;Script to name queue message key	
If GetVerbosity () == 0 then
Say (msg9, OT_MESSAGE) ; "Queue message"
EndIf
{control+E}
EndScript

Script AddressBook ()
;Script to name address book key
If GetVerbosity () == 0 then
	Say (msg10, OT_MESSAGE) ; "Address book"
EndIf
{control+L}
EndScript

Script Close ()
;Script to name close key
If GetVerbosity () == 0 then
	Say (msg11, OT_MESSAGE) ; "Close"
EndIf
{Control+W}
EndScript

Script Reply ()
;Script to name reply key
If GetVerbosity () == 0 then
	Say (msg12, OT_MESSAGE) ; "Reply"
EndIf
{control+R}
EndScript

Script ReplyWithOptions ()
;Script to name reply with options key
If GetVerbosity () == 0 then
	Say (msg12, OT_MESSAGE) ; "Reply"
EndIf
{control+shift+R}
EndScript

Script Attachment ()
;Script to name Attachment key
If GetVerbosity () == 0 then
	Say (msg13, OT_MESSAGE) ; "Attachment"
EndIf
{control+H}
EndScript

Script FilterMessages ()
;Script to name filter key
If GetVerbosity () == 0 then
	Say (msg14, OT_MESSAGE) ; "Filter messages"
EndIf
{control+J}
EndScript

Script TakeAddress ()
;Script to name take address key
If GetVerbosity () == 0 then
	Say (msg15, OT_MESSAGE) ; "Take address"
EndIf
{control+K}
EndScript















Script NewMessageFrom ()
; Added by Dave Baker 
; 1/99
; for reading the From field of messages
SaveCursor ()
If (! FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From)) then
	Say (msg79, OT_MESSAGE) ; "Not in message edit window"
	Return
EndIf

InvisibleCursor ()
RouteInvisibleToPc ()
MoveToWindow (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From))
NextWord () ; to ensure that we are actually in the window
If (GetControlID (GetCurrentWindow ()) != ID_From) then
	Say (msg85, OT_MESSAGE) ; "from"
	Say (msg82, ot_message) ; "not found"
	RestoreCursor ()
	Return
EndIf
Say (msg85, OT_CONTROL_NAME) ; "from"
SayWindow (GetCurrentWindow (), Read_Everything)
RestoreCursor ()
EndScript

Script NewMessageTo ()
;Script to read names in To field of message
; and edit them if necessary
; revised 1/99 by Dave Baker
If (! FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From)) then
	Say (msg79, OT_MESSAGE) ; "Not in message edit window"
	Return
EndIf
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
MoveToWindow (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_To))
If (GetControlID (GetCurrentWindow ()) != ID_To) then
	Say (msg33, OT_MESSAGE) ; "To"
	Say (msg82, OT_MESSAGE) ; "not found"
	RestoreCursor ()
	Return
EndIf
If (IsSameScript ()) then
	RoutePCToInvisible ()
	Return
EndIf
Say (msg33, OT_CONTROL_NAME) ; "to"
SayWindow (GetCurrentWindow (), Read_Everything)
If (GetVerbosity () == 0) then
	Say (msg83, OT_MESSAGE) ; "press twice to edit"
EndIf
RestoreCursor ()
EndScript

Script NewMessageSubject ()
; Added by Dave Baker
; to allow reading and editing of subject fields during message composition
If (! FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From)) then
	Say (msg79, OT_MESSAGE) ; "Not in message edit window"
	Return
EndIf

SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
MoveToWindow (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_Subject))
If (GetControlID (GetCurrentWindow ()) != ID_Subject) then
	Say (msg84, OT_MESSAGE) ; "subject"
	Say (msg82, OT_MESSAGE) ; "not found"
	RestoreCursor ()
	Return
EndIf
If (IsSameScript ()) then
	RoutePCToInvisible ()
	Return
EndIf
Say (msg84, OT_CONTROL_NAME) ; "subject"
SayWindow (GetCurrentWindow (), Read_Everything)
If (GetVerbosity () == 0) then
	Say (msg83, OT_MESSAGE) ; "press twice to edit"
EndIf
RestoreCursor ()
EndScript

Script NewMessageCC ()
;Script to speak name in CC field of message
; and edit it if necessary
; revised 1/99 by Dave Baker
; to allow movement to and editing the field
If (! FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From)) then
	Say (msg79, OT_MESSAGE) ; "Not in message edit window"
	Return
EndIf
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
MoveToWindow (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_Cc))
If (GetControlID (GetCurrentWindow ()) != ID_Cc) then
	Say (msg34, OT_MESSAGE) ; "cc"
	Say (msg82, OT_MESSAGE) ; "not found"
	RestoreCursor ()
	Return
EndIf
If (IsSameScript ()) then
	RoutePCToInvisible ()
	Return
EndIf
Say (msg34, OT_CONTROL_NAME) ; "cc"
SayWindow (GetCurrentWindow (), Read_Everything)
If (GetVerbosity () == 0) then
	Say (msg83, OT_MESSAGE) ; "press twice to edit"
EndIf
RestoreCursor ()
EndScript

Script NewMessageBCC ()
;Script to speak names in BCC field of new message
; and edit them if necessary
; revised 1/99 by Dave Baker
If (! FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_From)) then
	Say (msg79, OT_MESSAGE) ; "Not in message edit window"
	Return
EndIf
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
MoveToWindow (FindDescendantWindow (GetRealWindow (GetCurrentWindow ()), ID_BCc))
If (GetControlID (GetCurrentWindow ()) != ID_Bcc) then
	Say (msg35, OT_MESSAGE) ; "Bcc"
	Say (msg82, OT_MESSAGE) ; "not found"
	RestoreCursor ()
	Return
EndIf
If (IsSameScript ()) then
	RoutePCToInvisible ()
	Return
EndIf
Say (msg35, OT_CONTROL_NAME) ; "bcc"
SayWindow (GetCurrentWindow (), Read_Everything)
If (GetVerbosity () == 0) then
	Say (msg83, OT_MESSAGE) ; "press twice to edit"
EndIf
RestoreCursor ()
EndScript

Script ReplyToAuthor ()
;Script to reply to author of list server message instead of replying to list server.
;Courtesy of David Truong, Dave Maynard, and Patrick Burke
;Revised by David Maynard 1/26/99

;Generates a Reply to the original sender (From field). 
Say (msg36, OT_MESSAGE) ; "Reply to author, Please waite"
{space} ;make sure you are in an opened message 
Delay (5) 
{control+home} ; move to the top of the document 
Delay (2) ; Added 11/8/98 DCM
RouteJAWSToPc () 
JAWSCursor () 
; Find and copy the Sender's address to the Clipboard. 
; msg122 = "from:"
FindString (GetCurrentWindow (), msg122, s_top, s_restricted) 
If GetWord () == msg122 then 
	SpeechOff () ; added 11/8/98 DCM
	NextWord () 
	;msg123 = "@"
	While GetCharacter () != msg123 ; Added 11/8/98 DCM
		NextCharacter () ; Added 11/8/98 DCM
	EndWhile ; Added 11/8/98 DCM
	While GetCharacter () != " " ; Added 11/8/98 DCM
		PriorCharacter () ; Added 11/8/98 DCM
	EndWhile ; Added 11/8/98 DCM
	RoutePcToJaws() 
	PcCursor () 
	{SHIFT+END} 
	{CTRL+C} 
	; Create the Reply message and insert Sender's address. 
	{CTRL+R} 
	Delay (2) ;Added 11/8/98 DCM
	SaveCursor () 
	{alt + o} ; now at the "to" line 
	Delay (2) ; Added 11/8/98 DCM
	{CTRL+A} ;copy the contents of the ToBox
	{DELETE} 
	{CTRL+V} ;paste in new address
	Delay (3) 
	RestoreCursor () 
	{TAB} {TAB} {TAB} {TAB} {TAB} ;Now at message box
	Delay (10) 
	{enter} 
	{left arrow} 
	SpeechOn () ; Added 11/8/98 DCM
	Say (msg37, OT_MESSAGE) ; "Please type your message then press ctrl e to send."
Else 
Say (msg38, OT_MESSAGE) ; "make sure you are replying to a list serve message"
EndIf 
EndScript













Script MoveToMessageBody ()
var
	int counter,
	int iControl,
	handle hTemp,
	handle winhandle,
	string TheClass
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
let iControl = GetControlID (WinHandle)
If (iControl == ID_Signatures_List) then
	let hTemp = WinHandle
	let hTemp = GetParent (GetParent (hTemp))
	let hTemp = GetFirstChild (GetPriorWindow (hTemp))
	let hTemp = GetNextWindow (hTemp)
	If (GetWindowClass (hTemp) == WCEdit) then
		JawsCursor ()
		MoveToWindow (hTemp)
		LeftMouseButton ()
		RoutePcToJaws ()
		PcCursor ()
		Return
	EndIf
EndIf
If (! FindDescendantWindow (GetRealWindow (WinHandle), ID_From)) ||
(TheClass == WCDialog) then
	Say (msg79, OT_HELP) ; "Not in message edit window"
	Return
EndIf
If (GetControlID (WinHandle) == ID_Edit) then
	Say (msg80, OT_MESSAGE) ; "already in message body window"
	Return
EndIf
RouteInvisibleToPc ()
InvisibleCursor ()
; for Eudora Version 4 
If (GetEudoraVersion () >= 4) then
	let WinHandle = GetNextWindow (GetParent (GetCurrentWindow ()))
	If (GetControlID (WinHandle) != ID_Edit) then
		Say (msg81, OT_MESSAGE) ; "message body not found"
		PcCursor ()
		Return
	EndIf
	MoveToWindow (WinHandle)
	Delay (5)
	SayWindow (WinHandle, Read_Everything)
	RoutePCToInvisible ()
	PcCursor ()
	Return
EndIf ; end of version 4
; for Eudora version 3
; because the window structure is slightly different
	; for the Attach File edit field, after inserting file
If (GetControlID (GetFocus ()) == ID_Attach) then
	InvisibleCursor ()
	RouteInvisibleToPc ()
	MoveToWindow (FindDescendantWindow (GetAppMainWindow (GetFocus ()), ID_Edit))
	RoutePCToInvisible ()
	PCCursor ()
EndIf
While (GetWindowClass (GetFocus ()) != wcRichEdit) &&
(counter <=6) 
	let counter = counter + 1
	{tab}	
EndWhile
Delay (5)
If (GetWindowClass (GetFocus ()) != wcRichEdit) then	
	Say (msg81, OT_MESSAGE) ; "message body not found"
	PCCursor ()
	Return
EndIf ; end of class check
RouteInvisibleToPc ()
SayWindow (GetFocus (), Read_Everything)
PCCursor ()
EndScript



Script MessageBodyDelete ()
; by John Carson,
; Modified by DaveB
; for Eudora versions 3 and 4.x. 
var
	handle hWnd,
	handle WinHandle,
	int iId,
	string TheClass
let hWnd = FindDescendantWindow (GetAppMainWindow (winHandle), ID_ListBox)
let WinHandle = GetCurrentWindow ()
let iId = GetControlID (hWnd)
let TheClass = GetWindowClass (hWnd)
{Control + D}
; Verbosity Check 
let nSuppressEcho = false
if (GetVerbosity () == 0) then
	Say (msg99, OT_MESSAGE) ; "Delete"
EndIf ; End of Verbosity Check 
Pause ()
Delay (2)
; if no windows are open
if (! hWnd) &&
(TheClass == WCNoWindows) then
	If(GetVerbosity () == Beginner) then
		Say (msg96, OT_MESSAGE) ; "There are no mailboxes open at this time"
		Say (msg97, OT_MESSAGE) ; "The window with focus will not serve you until you open a mailbox"
		Say (msg98, OT_MESSAGE) ; "Press control plus 1 to open the Inbox"
	EndIf
	Return
EndIf
let hWnd = GetFocus ()
; For Messages list box (no matter what mailbox)
If (iId == ID_Messages_List) then
	Return
EndIf
if (iId == ID_View) ||
(iId == ID_Edit) then
	StopSpeech ()
	SaveCursor ()
	InvisibleCursor ()
	Delay (3)
	FindString (GetRealWindow (GetFocus ()), "From:", S_Top, S_Unrestricted)
	SayLine ()
	NextLine ()
SayLine ()
	RestoreCursor ()
	PCCursor ()
	SayLine ()
	Return 
EndIf
EndScript



Script SayNextCharacter ()
If (GlobalMenuMode > 0) then
	{RightArrow}
	Return
EndIf
PerformScript SayNextCharacter ()
EndScript

Script SayPriorCharacter ()
If (GlobalMenuMode > 0) then
	{LeftArrow}
	Return
EndIf
PerformScript SayPriorCharacter ()
EndScript
Script OpenFindResultsList ()
;script to activate results list in Find Messages Dialog, added by kag
; wn29 = "Messages",
var
	int nEcho
If StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), wn29) Then
	If FindString (GetAppMainWindow (GetCurrentWindow ()), msg131, S_TOP, S_UNRESTRICTED) Then; "matches in"
		NextLine ()
		NextLine ()
		PCCursor ()
		Say (msg132, OT_CONTROL_NAME); "Results list"
		LeftMouseButton ()
	Else
		Say (msg133, OT_MESSAGE); "Couldn't open results list"
	EndIf
Else
	let nEcho = GetJcfOption (OPT_TYPING_ECHO)
	If (nEcho) then
		Say (GetScriptKeyName ("OpenFindResultsList"), OT_STRING)
	EndIf
	{F6}
EndIf
EndScript
